//Copyright, 2002-2003, Astra Network Inc.  All Rights Reserved

//This source code has been published by Astra Network Inc. However, any
//use, reproduction, modification, distribution or transfer of this
//software, or any software which includes or is based upon any of this
//code, is only permitted if expressly authorized by a written license
//agreement from Astra. Contact your Astra representative directly for
//more information.

/*!
 * \file HC_Checkpoint.c
 *
 * Collection of functions relating to checkpoints.
 */

#include "checkpoint.h"

/*!
 * Sets the checkpoint. This is used during a rollback to determine
 * how far to rollback a function.
 *
 * \param sequence Sequence object for context
 * \param checkpoint The user-defined checkpoint value
 * \return An error code.
 */
int
HC_Checkpoint (HC_Sequence_t *sequence, unsigned long checkpoint)
{
  if (sequence)
    {
      /* Simply set the latest checkpoint in our sequence. */
      sequence->checkpoint = checkpoint;

      return (HC_OK);
    }
  return (HC_INVALIDSEQUENCE);
}
