//Copyright, 2002-2003, Astra Network Inc.  All Rights Reserved

//This source code has been published by Astra Network Inc. However, any
//use, reproduction, modification, distribution or transfer of this
//software, or any software which includes or is based upon any of this
//code, is only permitted if expressly authorized by a written license
//agreement from Astra. Contact your Astra representative directly for
//more information.

/*!
 * \file HC_Default.c
 * Collection of default functions.
 */

#include "checkpoint.h"

/*! 
 * Call the policy function for the given node.
 * \param sequence Sequence object.
 * \param userdata User-defined data.
 * \param event The event that has occured.
 * \param policy_data The policy-specific data.
 * \return An error code.
 */
int
HC_DefaultPolicy (HC_Sequence_t *sequence, void *userdata,
		  HC_PolicyEvent_t event, long policy_data)
{
  static int normretries = 0;
  static int rollbackretries = 0;
  long node;

  if (sequence)
    {
      switch (event)
	{
	case HC_NORMALSUCCESS:
	  normretries = rollbackretries = 0;
	  node = policy_data;
	  return (HC_Normal (sequence, node, userdata));

	case HC_NORMALFAIL:
	  rollbackretries = 0;
	  normretries++;
	  if (normretries >= 5)
	    return (HC_RollBackPrev (sequence));
	  else
	    return (HC_RollBackCurrent (sequence));

	case HC_ROLLBACKSUCCESS:
	  rollbackretries = 0;
	  return (HC_NormalCurrent (sequence, userdata));

	case HC_ROLLBACKFAIL:
	  normretries = 0;
	  rollbackretries++;
	  if (rollbackretries >= 5)
	    HC_Panic (sequence, "Unable to rollback node!");
	  else
	    return (HC_RollBackCurrent (sequence));

	case HC_INVALID_EVENT:
	  HC_Panic (sequence, "Policy called without an event set.",
		    event);
	default:
	  HC_Panic (sequence, "Unknown event %d passed to HC_DefaultPolicy",
		    event);
	}
    }
  return (HC_INVALIDSEQUENCE);
}
