//Copyright, 2002-2003, Astra Network Inc.  All Rights Reserved

//This source code has been published by Astra Network Inc. However, any
//use, reproduction, modification, distribution or transfer of this
//software, or any software which includes or is based upon any of this
//code, is only permitted if expressly authorized by a written license
//agreement from Astra. Contact your Astra representative directly for
//more information.

/*!
 * \file HC_Log.c
 * Collection of functions relating to logging.
 */

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>

#include "checkpoint.h"

/*!
 * Called to halt program execution because of a fatal error.
 * \param sequence Sequence object.
 * \param format Printf()-style format string.
 */
void
HC_Panic (HC_Sequence_t *sequence, const char *format, ...)
{
  va_list curr_arg;
  char logstring[256];

  if (sequence)
    {
      va_start (curr_arg, format);

      (void) vsnprintf (logstring, 256, format, curr_arg);

      (void) HC_Log (sequence, logstring);
    }
  exit (EXIT_FAILURE);
}

/*!
 * Prints an error to stderr.
 * \param sequence Sequence object.
 * \param format Printf()-style format string.
 */
int
HC_Log (HC_Sequence_t *sequence, const char *format, ...)
{
  va_list curr_arg;

  sequence = sequence;
  /* Just a placeholder for now, logging is rather undefined. */
  va_start (curr_arg, format);

  (void) vfprintf (stderr, format, curr_arg);
  fprintf (stderr, "\n");

  return (HC_OK);
}

/*! List of strings that correspond with system errors */
static const char *errlist[] = {
  "Success",
  "Failure",
  "Invalid Cookie",
  "Invalid Node",
  "Failed Allocation",
  "Failed Sequence"
};

/*! Convert from an error code to a string describing the error.
 * \param error The error code
 * \returns A contant string describing the error.
 */
const char *
HC_Strerror (int error)
{
  error = abs (error);
  if (error <= abs (HC_FINALERROR))
    return (errlist[error]);
  else
    return ("Invalid error");
}
