//Copyright, 2002-2003, Astra Network Inc.  All Rights Reserved

//This source code has been published by Astra Network Inc. However, any
//use, reproduction, modification, distribution or transfer of this
//software, or any software which includes or is based upon any of this
//code, is only permitted if expressly authorized by a written license
//agreement from Astra. Contact your Astra representative directly for
//more information.

/*!
 * \file HC_Stack.c
 * Collection of functions relating to the node index stack.
 */

#include <malloc.h>

#include "checkpoint_int.h"

/*!
 * Pushes a node onto the stack.
 * \param sequence The sequence object.
 * \param node The node to be pushed.
 * \return An error code.
 */
int
HCI_PushNode (HC_Sequence_t *sequence, long node)
{
  HC_NodeStack_t *newnode;

  if (sequence)
    {
      newnode = malloc (sizeof (HC_NodeStack_t));
      if (!newnode)
	return (HC_FAILEDALLOC);

      newnode->index = node;
      newnode->next = (struct HC_NodeStack_s *) sequence->index_stack;
      sequence->index_stack = newnode;

      return (HC_OK);
    }
  return (HC_INVALIDSEQUENCE);
}

/*!
 * Pops a node from the stack.
 * \param sequence The sequence object.
 * \return The node popped from the stack or an error code (<0)
 */
long
HCI_PopNode (HC_Sequence_t *sequence)
{
  HC_NodeStack_t *poppednode;
  long poppedindex;

  if (sequence)
    {
      poppednode = sequence->index_stack;

      if (poppednode)
	{
	  sequence->index_stack = poppednode->next;
	  poppedindex = poppednode->index;

	  free (poppednode);
	}
      else
	{
	  return (HC_FAIL);
	}

      return (poppedindex);
    }
  return (HC_INVALIDSEQUENCE);

}
