## Copyright, 2001, Astra Network Inc.  All Rights Reserved

## This source code has been published by Astra Network Inc. However, any
## use, reproduction, modification, distribution or transfer of this
## software, or any software which includes or is based upon any of this
## code, is only permitted if expressly authorized by a written license
## agreement from Astra. Contact your Astra representitive directly for
## more information.

TOPDIR:=%%TOPDIR%%
include $(TOPDIR)/mkfiles/def_glob.mk

LIBS:=$(wildcard */)
LIBS_MAKEFILES:=$(foreach dir, $(LIBS), $(addsuffix Makefile, $(dir)))

all: $(LIBS)

$(LIBS): $(LIBS_MAKEFILES)
	$(MAKE) -C $@

install deps test clean: $(LIBS_MAKEFILES)
	$(foreach dir, $(LIBS), $(MAKE) -C $(dir) $@; ) 

# FIX ME - I need a prerequisit here.
$(LIBS_MAKEFILES): 
	$(CPMKFILE) $(TOPDIR)/lib/$(dir $@)lib.mk $@

Makefile: $(TOPDIR)/lib/component.mk
	$(CPMKFILE) $^ $@
	@echo "ERROR: Makefile was out of date, it has been updated. Please remake." && /bin/false

# FIX ME - the libs target is not supposed to be phony, it just
#          needs to as there is no prerequisite
.PHONY: $(LIBS) install deps test clean all $(LIBS_MAKEFILES)
