## Copyright, 2001, Astra Network Inc.  All Rights Reserved

## This source code has been published by Astra Network Inc. However, any
## use, reproduction, modification, distribution or transfer of this
## software, or any software which includes or is based upon any of this
## code, is only permitted if expressly authorized by a written license
## agreement from Astra. Contact your Astra representitive directly for
## more information.

TOPDIR:=%%TOPDIR%%
include $(TOPDIR)/mkfiles/def_glob.mk

CWD:=$(shell /bin/pwd)
CURLIB:=$(notdir $(CWD))

LIBDIR:=$(TOPDIR)/lib

SRCDIR:=$(LIBDIR)/$(CURLIB) $(LIBDIR)/$(CURLIB)/$(PLAT) $(LIBDIR)/$(CURLIB)/$(PLAT)/$(ARCH)

VPATH:=$(SRCDIR)

SRCS:=$(sort $(foreach dir,$(SRCDIR), $(wildcard $(dir)/*.c)))

OBJS:=$(sort $(addsuffix .o, $(basename $(notdir $(SRCS)))))

INCLUDES:=$(foreach dir, $(SRCDIR), -I $(dir)) -I $(TOPDIR)/include

CFLAGS:=$(INCLUDES) $(DEBUG)

all: lib$(CURLIB).a

install: lib$(CURLIB).a
	cp $< $(INSTALLDIR)/../lib

lib$(CURLIB).a: $(OBJS)
	$(AR) $@ $(OBJS)

clean:
	-rm -f *.o *.a deps.mk


MKFILELOCATION:=$(TOPDIR)/lib/$(CURLIB)/lib.mk
DEPSFROM:=$(SRCS)
TESTMKFILE:=test/test.mk

include $(MKFILEDIR)/def_target.mk
