// Copyright, 2001-2003, Astra Network Inc.  All Rights Reserved

// This source code has been published by Astra Network Inc. However, any
// use, reproduction, modification, distribution or transfer of this
// software, or any software which includes or is based upon any of this
// code, is only permitted if expressly authorized by a written license
// agreement from Astra. Contact your Astra representative directly for
// more information.


#include "quad.h"

/*
 * Assign a quad to a long.
 * 
 *  Do a simple bit truncation.
 */


long
quad_qtol (a)
     ___quad_t a;
{
  union uu aa;
  long result;

  aa.q = a;
  result = aa.ul[L];

  return (result);
}




/* This implementation is arguably better as it does more than
 * a simple bit truncation, but since gcc just does a bit truncation
 * that is what we will do.
 */
#if 0				/* Commented out */

#define LONG_SIGN_BIT   (1L << (LONG_BITS-1))

#define LONG_SIGN_BIT_ON(x)  ((x) | LONG_SIGN_BIT)
#define LONG_SIGN_BIT_OFF(x) ((x) & ~LONG_SIGN_BIT)

long
quad_qtol (a)
     ___quad_t a;
{
  union uu aa;
  long result;
  aa.q = a;
  if (aa.sl[H] < 0)
    {				/* The quad is negative */
      if (aa.sl[H] != -1)
	{			/* The quad's value is less than LONG_MIN */
	  return LONG_MIN;
	}
      result = aa.ul[L];
      /* Set the sign bit */
      result = LONG_SIGN_BIT_ON (result);
    }
  else
    {				/* Quad is zero or positive */
      if (aa.sl[H] != 0)
	{			/* The quad's value is greater than LONG_MAX */
	  return LONG_MAX;
	}
      result = aa.ul[L];
      /* Unset the sign bit */
      result = LONG_SIGN_BIT_OFF (result);
    }
  return (result);
}

#endif /* #if 0 */
