// Copyright, 2001-2003, Astra Network Inc.  All Rights Reserved

// This source code has been published by Astra Network Inc. However, any
// use, reproduction, modification, distribution or transfer of this
// software, or any software which includes or is based upon any of this
// code, is only permitted if expressly authorized by a written license
// agreement from Astra. Contact your Astra representative directly for
// more information.

#include "quad.h"

/*
 * Swap the byte ordering. ie convert from big to little endian or vice versa.
 */

# define SWAPLONG(x)	((((x) >> 24) & 0xff)     | (((x) >> 8 ) & 0xff00) | \
                         (((x) & 0xff00) << 8)  | (((x) & 0xff) << 24))
___quad_t
quad_swap (a)
     ___quad_t a;
{
  union uu aa, bb;

  aa.q = a;
  bb.ul[0] = SWAPLONG (aa.ul[1]);
  bb.ul[1] = SWAPLONG (aa.ul[0]);

  return (bb.q);
}
