// Copyright, 2001-2003, Astra Network Inc.  All Rights Reserved

// This source code has been published by Astra Network Inc. However, any
// use, reproduction, modification, distribution or transfer of this
// software, or any software which includes or is based upon any of this
// code, is only permitted if expressly authorized by a written license
// agreement from Astra. Contact your Astra representative directly for
// more information.

#include <stdio.h>
#include <quad.h>
#include <time.h>

int
main (int argc, char *argv[])
{
  union
  {
    ___quad_t q;
    long long ll;
    unsigned long v[2];
  }
  a, b, m;
  char buf[300];
  extern ___quad_t quad_muldi3 (___quad_t, ___quad_t);
  int rounds, i, errors = 0;
  long long ll;

  if (argc == 2)
    {
      rounds = (int) atoi (argv[1]);
    }
  else
    {
      printf ("Enter a number on the command line\n");
      exit (1);
    }
  printf ("Testing multiplication.\n");
  printf ("0|                    |100\e[24D");

  srand48 (time (NULL));
  for (i = 0; i < rounds * 100; i++)
    {
      a.v[0] = lrand48 ();
      a.v[1] = lrand48 ();
      b.v[0] = lrand48 ();
      b.v[1] = lrand48 ();

      m.q = quad_muldi3 (a.q, b.q);
      ll = a.ll * b.ll;
      if (m.ll == ll)
	{
	  if (i % (rounds * 100 / 20) == 0)
	    {
	      printf (".");
	      fflush (stdout);
	    }
	}
      else
	{
	  printf ("Wrong. %llX * %llX != %llX (gcc %llX)\n",
		  a.ll, b.ll, m.ll, ll);
	  errors++;
	}

    }

  if (errors)
    {
      printf ("\n%d errors.\n", errors);
      exit (1);
    }
  else
    {
      printf ("\nNo errors\n");
      exit (0);
    }

}
