## Copyright, 2001, Astra Network Inc.  All Rights Reserved

## This source code has been published by Astra Network Inc. However, any
## use, reproduction, modification, distribution or transfer of this
## software, or any software which includes or is based upon any of this
## code, is only permitted if expressly authorized by a written license
## agreement from Astra. Contact your Astra representitive directly for
## more information.

TOPDIR:=%%TOPDIR%%
include $(TOPDIR)/mkfiles/def_glob.mk

COMPONENTS_RAW:=lib ola olc olrt examples

COMPONENTS:=$(filter $(COMPONENTS_RAW),$(subst /,,$(wildcard */)))

.PHONY: $(COMPONENTS)

all: Makefile $(COMPONENTS)

ola: ola/Makefile
	$(MAKE) -C $@

ola/Makefile: $(TOPDIR)/ola/component.mk
	$(CPMKFILE) $^ $@

olc: olc/Makefile
	$(MAKE) -C $@

olc/Makefile: $(TOPDIR)/olc/component.mk
	$(CPMKFILE) $^ $@

olrt: olrt/Makefile
	$(MAKE) -C $@

olrt/Makefile: $(TOPDIR)/olrt/component.mk
	$(CPMKFILE) $^ $@

lib: lib/Makefile
	$(MAKE) -C $@

lib/Makefile: $(TOPDIR)/lib/component.mk
	$(CPMKFILE) $^ $@

test: test/Makefile
	$(foreach dir, $(COMPONENTS), $(MAKE) -C $(dir) $@; )
	$(MAKE) -C $@

test/Makefile: $(TOPDIR)/test/test.mk
	@mkdir test 2> /dev/null || /bin/true
	$(CPMKFILE) $^ $@

examples: examples/Makefile
	$(MAKE) -C $@

examples/Makefile: $(TOPDIR)/examples/component.mk
	$(CPMKFILE) $^ $@

clean install deps: $(foreach dir, $(COMPONENTS), $(dir)/Makefile )
	$(foreach dir, $(COMPONENTS), $(MAKE) -C $(dir) $@; )

Makefile: $(TOPDIR)/mkfiles/build.mk
	$(CPMKFILE) $< $@
	@echo "ERROR: Makefile was out of date, it has been updated. Please remake." && /bin/false


