## Copyright, 2001, Astra Network Inc.  All Rights Reserved

## This source code has been published by Astra Network Inc. However, any
## use, reproduction, modification, distribution or transfer of this
## software, or any software which includes or is based upon any of this
## code, is only permitted if expressly authorized by a written license
## agreement from Astra. Contact your Astra representitive directly for
## more information.

####################################################
# Global makefile defaults.
#
# Most makefiles will include this file either
# directly or indirectly(ie modules.)
#
# Assumptions: TOPDIR is defined (and valid)
#
####################################################

ifndef CONFIG
 CONFIG:=$(shell TOPDIR=$(TOPDIR) $(TOPDIR)/mkfiles/getconfig.sh)
endif

export CONFIG
ARCH:=$(word 1,$(CONFIG))
PLAT:=$(word 3,$(CONFIG))

YACC=bison --defines -v
LEX=flex
# Lex library
#LEXLIB=-lfl
# Quad Integer library
QUADLIB:=-lquad -L$(TOPDIR)/build-$(PLAT)/lib/quad 
# Realtime extentions library
RTLIB=
# Dynamic loading library
DLLIB=
DLFLAGS=
# Socket library
SOCKLIB=
# unix lib for qnx4
UNIXLIB=

LINT=lclint

ALLWARN:=-Wall

INSTALLDIR=/usr/local/bin

ifeq "$(PLAT)" "nto"
 CC:=qcc
 AR:=ar rc
 DEPS=TOPDIR="$(TOPDIR)" CFLAGS="$(CFLAGS)" $(TOPDIR)/mkfiles/makedep.sh
 LINTDEFINES=-D__GNUC__ -D__X86__ -D__LITTLEENDIAN__ -D__QNX__ -D__QNXNTO__
 LINTFLAGS=$(LINTDEFINES) -warnunixlib +unixlib -duplicatequals
 SOCKLIB:=-lsocket
 DLFLAGS:=-Wl,--export-dynamic -Bdynamic
endif
ifeq "$(PLAT)" "qnx"
 PLAT:=qnx4

## FIXME I have to tell cc to create 386 code(-3) to workaround a bug that
## caused cc to hang when compiling pcode.l
 CC:=cc -3 -Q -DNO_MUTEX
# CC:=qcc
 AR:=ar rc
 DEPS=TOPDIR="$(TOPDIR)" CFLAGS="$(CFLAGS)" $(TOPDIR)/mkfiles/makedep.sh
 ALLWARN:=-w9
## FIXME Path is wrong. Find a better way to do this.
 QUADLIB:=-lquad -L $(TOPDIR)/build-qnx4/lib/quad 
 UNIXLIB:=-lunix
endif

ifeq "$(PLAT)" "linux"
 CC:=gcc
 AR:=ar rc
 DEPS=TOPDIR="$(TOPDIR)" CFLAGS="$(CFLAGS)" $(TOPDIR)/mkfiles/makedep.sh
 DLLIB=-ldl
 DLFLAGS:=-Wl,--export-dynamic -Bdynamic
 RTLIB=-lrt
endif

ifeq "$(PLAT)" "solaris2.8"
 CC:=gcc
 AR:=ar rc
 DEPS=TOPDIR="$(TOPDIR)" CFLAGS="$(CFLAGS)" $(TOPDIR)/mkfiles/makedep.sh
 RTLIB=-lrt
 SOCKLIB=-lsocket
 DLFLAGS:=-Wl,--export-dynamic -Bdynamic
endif

DEBUG=-g $(ALLWARN)

OLADIR    =$(TOPDIR)/ola
OLCDIR    =$(TOPDIR)/olc
OLRTDIR   =$(TOPDIR)/olrt

MODDIR    =$(OLRTDIR)/modules
INCLUDEDIRS=$(addprefix -I ,$(TOPDIR)/include $(TOPDIR)/../build $(TOPDIR))
MKFILEDIR =$(TOPDIR)/mkfiles

CPMKFILE  =$(MKFILEDIR)/cpmkfile.sh $(TOPDIR)

.PHONY: all clean test docs deps default install

RECURSIVE_TARGETS=clean test deps install


