## Copyright, 2001, Astra Network Inc.  All Rights Reserved

## This source code has been published by Astra Network Inc. However, any
## use, reproduction, modification, distribution or transfer of this
## software, or any software which includes or is based upon any of this
## code, is only permitted if expressly authorized by a written license
## agreement from Astra. Contact your Astra representitive directly for
## more information.

####################################################
# Defaults for making modules
#
#  - We assume that TOPDIR is defined.
#    It is typically are used to find this file to include it
#    anyway, so this is a fair assumption.
#
####################################################

include $(TOPDIR)/mkfiles/def_glob.mk

CWD:=$(shell /bin/pwd)
CURMOD:=$(notdir $(CWD))
MODNAME:=$(subst mod_,,$(CURMOD))

SRCDIR:=$(MODDIR)/$(CURMOD) $(MODDIR)/$(CURMOD)/$(PLAT) $(MODDIR)/$(CURMOD)/$(PLAT)/$(ARCH)

VPATH:=$(SRCDIR)

SRCS:=$(sort $(foreach dir,$(SRCDIR), $(wildcard $(dir)/*.c)))
OBJS:=$(sort $(addsuffix .o, $(basename $(notdir $(SRCS)))))

INCLUDES:=$(foreach dir, $(SRCDIR), -I$(dir)) -I$(TOPDIR)/include -I./

CFLAGS:=$(INCLUDES) -shared $(DEBUG)

TESTMKFILE:=$(TOPDIR)/mkfiles/test.mk

all: lib$(CURMOD)S.a


