#!/bin/sh
## Copyright, 2001, Astra Network Inc.  All Rights Reserved

## This source code has been published by Astra Network Inc. However, any
## use, reproduction, modification, distribution or transfer of this
## software, or any software which includes or is based upon any of this
## code, is only permitted if expressly authorized by a written license
## agreement from Astra. Contact your Astra representitive directly for
## more information.


for i in $@; do
		    #replace .c with .o:
	echo -n $i | sed 's/\.c/\.o:/' |\
		    #remove path from .o file
		sed 's,.*/\(.*\)$,\1,'
	cc -E $CFLAGS $i |\
		    #only select include lines
		grep -E '(^# )|(^#line)' |\
		    #only select lines beginning with TOPDIR or not a /
		grep -E "(\"$TOPDIR)|(\"[^/].*\")" |\
		    #extract filename
		sed -n 's,^#[^"]*"\(.*\)".*$, \1,p' |\
		    #sort, remove duplicates and remove newlines
		sort | uniq | tr -d "\\012"
	echo ''
done
