#!/usr/bin/perl

##Copyright, 2001, Astra Network Inc.  All Rights Reserved

##This source code has been published by Astra Network Inc. However, any
##use, reproduction, modification, distribution or transfer of this
##software, or any software which includes or is based upon any of this
##code, is only permitted if expressly authorized by a written license
##agreement from Astra. Contact your Astra representitive directly for
##more information.

@file = <>;
chomp @file;

$pcom = 0; # print comments

foreach (@file) {
	last if (not /Name:/i) and (not /^\/\//) and $pcom;
	next if (not /Name:/i) and (not (/^\/\// and $pcom));
	if (/^\/\//) {
		print;
		print "\n";
	} else {
		$name = $_;
		$name =~ s/Name: //i;
		$pcom = 1;
	}
}

$NAME = uc $name;
$name = lc $name;

print "\n";
print "#ifndef ",$NAME,"_OLARG_H\n";
print "#define ",$NAME,"_OLARG_H\n";
print "\n";
print "#include \"olmod.h\"\n";
print "\n";
print "const olmod_argtype_t ",$name,"_static_argtypes[] = {\n";

$pcom = 0;
foreach (@file) {
	$pcom = 0 if (not /Static:/i) and (not /^\/\//);
	next if (not /Static:/i) and (not (/^\/\// and $pcom));
	if (/^\/\//) {
		if ($pcom == 1) {
			print "\t",$_,"\n";
			$pcom = 2;
		} else {
			print "\t\t\t",$_,"\n";
		}
	} else {
		if ($pcom) {
			print "\n";
		}
		if (/int/i) {
			print "\tkInt,   ";
		} else {
			print "\tkString,";
		}
		$pcom = 1;
	}
}

print "\tkEndList\n";
print "};\n";
print "\n";
print "const olmod_argtype_t ",$name,"_dynamic_argtypes[] = {\n";

$pcom = 0;
foreach (@file) {
	$pcom = 0 if (not /Dynamic:/i) and (not /^\/\//);
	next if (not /Dynamic:/i) and (not (/^\/\// and $pcom));
	if (/^\/\//) {
		if ($pcom == 1) {
			print "\t",$_,"\n";
			$pcom = 2;
		} else {
			print "\t\t\t",$_,"\n";
		}
	} else {
		if ($pcom) {
			print "\n";
		}
		if (/int/i) {
			print "\tkInt,   ";
		} else {
			print "\tkString,";
		}
		$pcom = 1;
	}
}

print "\tkEndList\n";
print "};\n";

$pcom = 0;
foreach (@file) {
	$pcom = 0 if (not /Define:/i) and (not /^\/\//);
	next if (not /Define:/i) and (not (/^\/\// and $pcom));
	if (/^\/\//) {
		if ($pcom == 1) {
			print "\t",$_,"\n";
			$pcom = 2;
		} else {
			print "\t\t\t",$_,"\n";
		}
	} else {
		if ($pcom) {
			print "\n";
		}
		$tmp = $_;
		$tmp =~ s/Define: //i;
		print "#define ",$tmp;
		$pcom = 1;
	}
}


print "\n";
print "#endif\n";
