#!/usr/bin/perl

##Copyright, 2001, Astra Network Inc.  All Rights Reserved

##This source code has been published by Astra Network Inc. However, any
##use, reproduction, modification, distribution or transfer of this
##software, or any software which includes or is based upon any of this
##code, is only permitted if expressly authorized by a written license
##agreement from Astra. Contact your Astra representitive directly for
##more information.

@file = <>;
chomp @file;

$num_dyn = 0;
$num_stat = 0;
$num_def = 0;

foreach (@file)
  {
    if( /Name:/ )
      {
	$name = $_;
	$name =~ s/Name: //i;
      }
    elsif( /Dynamic:/i )
      {
	if( /int/i )
	  {
	    $dynamic[$num_dyn] = "num";
	  }
	else
	  {
	    $dynamic[$num_dyn] = "string";
	  }
	$num_dyn++;
      }
    elsif( /Static:/i )
      {
	if( /int/i )
	  {
	    $static[$num_stat] = "num";
	  }
	else
	  {
	    $static[$num_stat] = "string";
	  }
	$num_stat++;
      }
    elsif( /Define:/i )
      {
	$define[$num_def] = $_;
	$define[$num_def] =~ s/Define: //i;
	$num_def++;
      }
  }

print "module ", $name, " (";

for( $i=0; $i < $num_stat; $i++ )
  {
    print $static[0]        if( $i == 0 );
    print ", ", $static[$i] if( $i != 0 );
  }
print ") ";

print "(";
for( $i=0; $i < $num_dyn; $i++ )
  {
    print $dynamic[0]        if( $i == 0 );
    print ", ", $dynamic[$i] if( $i != 0 );
  }
print ");\n";

for( $i=0; $i < $num_def; $i++ )
  {
    print "define ", $define[$i], "\n";
  }
