## Copyright, 2001, Astra Network Inc.  All Rights Reserved

## This source code has been published by Astra Network Inc. However, any
## use, reproduction, modification, distribution or transfer of this
## software, or any software which includes or is based upon any of this
## code, is only permitted if expressly authorized by a written license
## agreement from Astra. Contact your Astra representitive directly for
## more information.

TOPDIR:=%%TOPDIR%%
include $(TOPDIR)/mkfiles/def_glob.mk

MODULES:=$(wildcard mod_*/)
MODULES_MAKEFILES:=$(foreach dir, $(MODULES), $(addsuffix Makefile, $(dir)))
MOD_INCLUDE_DIRS:=$(foreach dir, $(MODULES), -I$(dir) -I$(MODDIR)/$(dir) -I$(MODDIR)/$(dir)/$(PLAT) -I$(MODDIR)/$(dir)/$(PLAT)/$(ARCH))

LIBS:=$(foreach dir, $(MODULES), -l$(subst /,,$(dir))S)

CWD:=$(shell /bin/pwd)
CURPKG:=$(notdir $(CWD))

VPATH:=$(MODULES)

CFLAGS:= $(MOD_INCLUDE_DIRS) $(INCLUDEDIRS) -I ./ $(foreach dir,$(MODULES), -L$(dir)) -shared $(DEBUG)

all: lib$(CURPKG).so

lint: $(MODULES_MAKEFILES)
	make -C $(MODULES) lint

lib$(CURPKG).so: $(MODULES) table.c
	$(CC) $(CFLAGS) $(LIBS) table.c -o $@

install: lib$(CURPKG).so
	cp $< $(INSTALLDIR)/../lib/overlord

TABLEDEPS:=$(foreach dir, $(MODULES),$(dir)/$(subst mod_,,$(subst /,,$(dir))_olmod.h))

table.c: $(TABLEDEPS)
	@echo "Generating global_overlord_table in table.c" 
	@echo "//Automatically generated, do not edit." > table.c
	@echo "#include <olmod.h>" >> table.c
	@(for x in $(MODULES); do echo "#include <$$x.h>"; done) | sed s/mod_//g | sed s,/.h,.h,g >> table.c
	@echo "const olmod_module_t object_global_overlord_table[] = {" >> table.c
	@cat /dev/null $(TABLEDEPS) >> table.c
	@echo "END_OBJECT_TABLE };" >> table.c

$(MODULES): $(MODULES_MAKEFILES)
	$(MAKE) -C $@

# FIX ME - I need a prerequisit here.
$(MODULES_MAKEFILES): 
	$(CPMKFILE) $(MODDIR)/$(dir $@)mod.mk $@

clean:
	-rm -f *.o *.so table.c
	$(foreach dir, $(MODULES), $(MAKE) -C $(dir) clean;)

.PHONY: $(MODULES) clean all table.c $(MODULES_MAKEFILES)




