## Copyright, 2001, Astra Network Inc.  All Rights Reserved

## This source code has been published by Astra Network Inc. However, any
## use, reproduction, modification, distribution or transfer of this
## software, or any software which includes or is based upon any of this
## code, is only permitted if expressly authorized by a written license
## agreement from Astra. Contact your Astra representitive directly for
## more information.

TOPDIR:=%%TOPDIR%%
include $(TOPDIR)/mkfiles/def_glob.mk

VPATH:= $(OLADIR) ./
CFLAGS:=$(INCLUDEDIRS) -I $(OLADIR) $(DEBUG)

OBJS = pcode.o main.o
CODE = pcode.c main.c

all: $(TOPDIR)/version.h ola

$(TOPDIR)/version.h:
	$(MAKE) -C $(TOPDIR)/../build version.h

ola: $(OBJS)
	$(CC) $^ -o $@ $(LEXLIB) $(QUADLIB) $(DEBUG)

pcode.c: pcode.l
	$(LEX) -o$@ $^

lint: pcode.c
	$(LINT) $(INCLUDEDIRS) -I$(OLADIR) $(LINTFLAGS) $(OLADIR)/main.c pcode.c

clean:
	rm -f ola $(OBJS) pcode.c *.err

install: ola
	cp ola $(INSTALLDIR)

deps: $(SRCS)
	$(DEPS) $^ > deps.mk

-include deps.mk

test: test/Makefile
	$(MAKE) -C test test

test/Makefile: $(TOPDIR)/ola/test/test.mk
	@mkdir test 2> /dev/null || /bin/true
	$(CPMKFILE) $< $@