## Copyright, 2001, Astra Network Inc.  All Rights Reserved

## This source code has been published by Astra Network Inc. However, any
## use, reproduction, modification, distribution or transfer of this
## software, or any software which includes or is based upon any of this
## code, is only permitted if expressly authorized by a written license
## agreement from Astra. Contact your Astra representitive directly for
## more information.

TOPDIR:=%%TOPDIR%%
include $(TOPDIR)/mkfiles/def_glob.mk

VPATH:= $(OLCDIR) ./
CFLAGS:=$(INCLUDEDIRS) -I $(OLCDIR) -I ./ $(DEBUG)
SRCS:=$(OLCDIR)/*.c
OBJS:=$(addsuffix .o, $(basename $(notdir $(wildcard $(OLCDIR)/*.[c]))))

olc: $(TOPDIR)/version.h $(OBJS) overlord.tab.o lex.yy.o
	$(CC) $(CFLAGS) $(OBJS) overlord.tab.o lex.yy.o -Bstatic -o $@

$(TOPDIR)/version.h:
	$(MAKE) -C $(TOPDIR)/../build version.h

lint: lex.yy.c overlord.tab.c overlord.tab.h
	$(LINT) $(INCLUDEDIRS) $(LINTFLAGS) $(SRCS)

lex.yy.o: lex.yy.c overlord.tab.h

overlord.tab.c overlord.tab.h: overlord.y
	$(YACC) $^ -o $@

lex.yy.c: overlord.l
	$(LEX) $^

Makefile: $(OLCDIR)/component.mk
	$(CPMKFILE) $^ $@
	@echo "ERROR: Makefile was out of date, it has been updated. Please remake." && /bin/false

clean:
	-rm -f *.o olc *.output *.tab.* *.yy.*

install: olc
	cp olc $(INSTALLDIR)

deps: $(SRCS)
	$(DEPS) $^ > deps.mk

-include deps.mk

test: test/Makefile
	$(MAKE) -C test test

test/Makefile: $(TOPDIR)/olc/test/test.mk
	@mkdir test 2> /dev/null || /bin/true
	$(CPMKFILE) $< $@

