// Copyright, 2001-2003, Astra Network Inc.  All Rights Reserved

// This source code has been published by Astra Network Inc. However, any
// use, reproduction, modification, distribution or transfer of this
// software, or any software which includes or is based upon any of this
// code, is only permitted if expressly authorized by a written license
// agreement from Astra. Contact your Astra representative directly for
// more information.

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <string.h>
#include "defines.h"

nebuloid_t *
new_nebuloid (char *plugname, char *instname, state_node_t * args,
	      unsigned int interval, state_node_t * statements)
{
  nebuloid_t *newneb;

  if (plugname == NULL || instname == NULL)
    yyfatalerror ("No name for nebuloid (Out of memory?)");

  if (interval < 0)
    {
      yyerror ("Can't have negative interval for nebuloid \"%s\"", instname);
      return (NULL);
    }

  newneb = malloc (sizeof (nebuloid_t));
  if (newneb == NULL)
    {
      yyfatalerror ("Out of memory");
    }
  newneb->plugin = strdup (plugname);
  newneb->name = strdup (instname);

  if (!newneb->plugin || !newneb->name)
    {
      if (newneb->plugin)
	free (newneb->plugin);
      if (newneb->name)
	free (newneb->name);
      free (newneb);
      yyfatalerror ("Out of memory");
    }
  newneb->args = args;
  newneb->interval = interval;
  newneb->statements = statements;

  return (newneb);
}

policy_t *
new_policy (pt_t type, void *data, policy_t * head,
	    unsigned int /*@unused@ */ context)
{
  policy_t *pol;

  if (!data)
    yyfatalerror ("No data for policy (Out of memory?)");

  pol = malloc (sizeof (policy_t));

  if (!pol)
    yyfatalerror ("Out of memory");

  pol->type = type;
  pol->pol_data = data;
  pol->next = head;

  return (pol);
}

system_t *
new_system (dependency_t * deps, policy_t * pol)
{
  system_t *nsys;

  nsys = malloc (sizeof (system_t));

  if (!nsys)
    yyfatalerror ("Out of memory");

  nsys->depends = deps;
  nsys->policy = pol;

  return (nsys);
}

dependency_t *
new_dependency (char *name, dependency_t * head)
{
  dependency_t *dep;

  if (!name)
    yyfatalerror ("No name for dependency (Out of memory?)");

  dep = malloc (sizeof (dependency_t));

  if (!dep)
    yyfatalerror ("Out of memory");

  dep->next = head;
  dep->name = strdup (name);

  if (!dep->name)
    {
      free (dep);
      yyfatalerror ("Out of memory");
    }

  dep->lineno = yylineno;
  dep->tokpos = yytokenpos;
  return (dep);
}

process_t *
new_process (char *name, unsigned int interval, dependency_t * dep,
	     policy_t * pol, unsigned int /*@unused@ */ context)
{
  process_t *process;

  if (!name)
    yyfatalerror ("No name given for process (Out of memory?)");

  process = malloc (sizeof (process_t));
  if (!process)
    yyfatalerror ("Out of memory");

  process->name = strdup (name);

  if (!process->name)
    yyfatalerror ("Out of memory");

  process->interval = interval;
  process->depends = dep;
  process->policy = pol;
  process->context = context;
  process->nextstart = NULL;

  return (process);
}

proc_t *
new_proc (char *name, unsigned int interval, state_node_t * statements)
{
  proc_t *proc;

  if (!name)
    yyfatalerror ("No name for proc (Out of memory?)");

  proc = malloc (sizeof (proc_t));

  if (proc == NULL)
    {
      yyfatalerror ("Out of memory");
    }

  proc->name = strdup (name);
  if (!proc->name)
    {
      free (proc);
      yyfatalerror ("Out of memory");
    }

  proc->interval = interval;
  proc->statements = statements;

  return (proc);
}

start_t *
new_start (state_node_t * statements)
{
  start_t *proc;

  proc = malloc (sizeof (start_t));
  if (!proc)
    yyfatalerror ("Out of memory");

  proc->statements = statements;

  return (proc);
}

restart_t *
new_restart (state_node_t * statements)
{
  restart_t *proc;

  proc = malloc (sizeof (restart_t));
  if (!proc)
    yyfatalerror ("Out of memory");

  proc->statements = statements;

  return (proc);
}

dependfail_t *
new_dependfail (state_node_t * statements)
{
  dependfail_t *proc;

  proc = malloc (sizeof (dependfail_t));
  if (!proc)
    yyfatalerror ("Out of memory");

  proc->statements = statements;

  return (proc);
}

state_node_t *
new_argument (state_node_t * data)
{
  state_node_t *arg;

  arg = malloc (sizeof (state_node_t));
  if (!arg)
    yyfatalerror ("Out of memory");

  arg->type = STATE_ARG;
  arg->d.arg.data = data;
  arg->d.arg.next = NULL;

  return (arg);
}

isup_t *
new_isup (unsigned int interval, state_node_t * statements)
{
  isup_t *isup;

  isup = malloc (sizeof (isup_t));
  if (!isup)
    yyfatalerror ("Out of memory");

  isup->interval = interval;
  isup->statements = statements;

  return (isup);
}

isalive_t *
new_isalive (state_node_t * statements)
{
  isalive_t *proc;

  proc = malloc (sizeof (isalive_t));
  if (!proc)
    yyfatalerror ("Out of memory");

  proc->statements = statements;

  return (proc);
}

sighandler_t *
new_sighandler (sh_t type, state_node_t * statements)
{
  sighandler_t *sig;

  sig = malloc (sizeof (sighandler_t));
  if (!sig)
    yyfatalerror ("Out of memory");

  sig->type = type;
  sig->statements = statements;

  return (sig);
}
