// Copyright, 2001-2003, Astra Network Inc.  All Rights Reserved

// This source code has been published by Astra Network Inc. However, any
// use, reproduction, modification, distribution or transfer of this
// software, or any software which includes or is based upon any of this
// code, is only permitted if expressly authorized by a written license
// agreement from Astra. Contact your Astra representative directly for
// more information.

#include "defines.h"
#if 0

int
test_new_nebuloid (void)
{
  nebuloid_t *neb1;
  state_node_t *arg;
  state_node_t *op;

  op = op (OP_RETURN_TRUE, 0);
  arg = new_argument (AT_NUM, con (42));

  neb1 = new_nebuloid ("TEST_PLUG", "test_name", arg, 50, op);
  if (!neb1 || strcmp (neb1->plugin, "TEST_PLUG") != 0 ||
      strcmp (neb1->name, "test_name") != 0 || neb1->arguments != arg ||
      neb1->interval != 50 || neb1->statements != op)
    {
      if (neb1)
	free (neb1);
      return (0);
    }

  free (neb1);

  neb1 = new_nebuloid ("TEST_PLUG", "test_name", NULL, -10, NULL);
  if (neb1)
    {
      free (neb1);
      return (0);
    }

  neb1 = new_nebuloid ("TEST_PLUG", "test_name", NULL, 0, NULL);
  if (!neb1)
    return (0);

  free (neb1);

  neb1 = new_nebuloid (NULL, "test_name", NULL, 0, NULL);
  if (neb1)
    {
      free (neb1);
      return (0);
    }

  neb1 = new_nebuloid ("TEST_PLUGIN", NULL, NULL, 0, NULL);
  if (neb1)
    {
      free (neb1);
      return (0);
    }

  free (arg);
  free (op);

  return (1);
}

int
test_new_argument (void)
{
  state_node_t *arg;
  state_node_t *thingie;

  thingie = ident ("test");
  arg = new_argument (AT_IDENT, thingie);
  free (thingie);

  if (!arg || arg->d.arg.type != AT_IDENT || strcmp (arg->d.arg.d.ident.name,
						     "test") != 0)
    {
      if (arg)
	free (arg);
      return (0);
    }

  free (arg);

  thingie = con (42);
  arg = new_argument (AT_NUM, thingie);
  free (thingie);

  if (!arg || arg->d.arg.type != AT_NUM || arg->d.arg.d.con.value != 42)
    {
      if (arg)
	free (arg);
      return (0);
    }

  free (arg);

  arg = new_argument (AT_STRING, NULL) if (arg)
    {
      free (arg);
      return (0);
    }

  thingie = ident ("test");
  arg = new_argument (AT_NUM, thingie);
  free (thingie);

  if (arg)
    {
      free (arg);
      return (0);
    }

  thingie = ident ("test");
  arg = new_argument (100, thingie);
  free (thingie);

  if (arg)
    {
      free (arg);
      return (0);
    }

  return (1);
}

int
test_new_policy (void)
{
  policy_t *pol1;
  policy_t *pol2;
  policy_t *pol3;
  process_t *process;

  process = new_process ("test", NULL, NULL);

  pol1 = new_policy (PT_PROCESS, process, NULL);
  pol2 = new_policy (PT_PROCESS, process, pol1);
  pol3 = new_policy (PT_PROCESS, process, pol2);

  if (!pol1 || !pol2 || !pol3 || pol1->defn != process || pol1->type !=
      PT_PROCESS)
    {
      if (pol1)
	free (pol1);
      if (pol2)
	free (pol2);
      if (pol3)
	free (pol3);
      if (process)
	free (process);
      return (0);
    }

  if (pol1->next != pol2 || pol2->next != pol3 || pol3->next != NULL)
    {
      free (pol1);
      free (pol2);
      free (pol3);
      free (process);
      return (0);
    }

  free (pol1);
  free (pol2);
  free (pol3);

  pol1 = new_policy (105, process, NULL);
  free (process);

  if (pol1)
    {
      free (pol1);
      return (0);
    }

  pol1 = new_policy (PT_START, NULL, NULL);

  if (pol1)
    {
      free (pol1);
      return (0);
    }

  return (1);
}

int
test_new_system (void)
{
  system_t *sys;

  sys = new_system (1, 2);
  if (!sys || sys->depends != 1 || sys->policy != 2)
    {
      if (sys)
	free (sys);
      return (0);
    }
  free (sys);

  sys = new_system (NULL, NULL);
  if (!sys)
    {
      return (0);
    }

  free (sys);

  return (1);
}

int
test_new_dependency (void)
{
  dependency_t *dep1;
  dependency_t *dep2;
  dependency_t *dep3;

  char *name = "namenamename";

  dep1 = new_dependency (NULL, NULL);
  if (dep1)
    {
      free (dep1);
      return (0);
    }

  dep1 = new_dependency ("depend1", NULL);
  dep2 = new_dependency ("depend2", dep1);
  dep3 = new_dependency (name, dep2);

  if (!dep1 || !dep2 || !dep3)
    {
      if (dep1)
	free (dep1);
      if (dep2)
	free (dep2);
      if (dep3)
	free (dep3);
      return (0);
    }

  if (dep1->next != dep2 || dep2->next != dep3 || dep3->next != NULL)
    {
      free (dep1);
      free (dep2);
      free (dep3);
      return (0);
    }

  // DON'T just copy pointers!
  if (strcmp (dep3->name, name) != 0 || dep3->name == name)
    {
      free (dep1);
      free (dep2);
      free (dep3);
      return (0);
    }

  free (dep1);
  free (dep2);
  free (dep3);
  return (1);
}

int
test_new_process (void)
{
  process_t *proc1;
  process_t *proc2;
  dependency_t *dep;
  policy_t *pol;

  proc1 = new_process ("test", NULL, NULL);
  if (!proc1)
    {
      return (0);
    }

  dep = new_dependency ("test", NULL);
  pol = new_policy (PT_PROCESS, proc1, NULL);

  proc2 = new_process ("spork", dep, NULL);
  if (!proc2)
    {
      free (dep);
      free (pol);
      return (0);
    }
  free (proc2);

  proc2 = new_process ("spork", NULL, pol);
  if (!proc2)
    {
      free (dep);
      free (pol);
      return (0);
    }
  free (proc2);

  proc2 = new_process ("spork", dep, pol);
  if (!proc2)
    {
      free (dep);
      free (pol);
      return (0);
    }

  if (strcmp (proc2->name, "spork") != 0 || proc2->depends != dep ||
      proc2->policy != pol)
    {
      free (dep);
      free (pol);
      free (proc2);
      return (0);
    }

  free (proc2);

  proc2 = new_process (NULL, dep, pol);
  if (proc2)
    {
      free (dep);
      free (pol);
      free (proc2);
      return (0);
    }

  free (dep);
  free (pol);

  return (1);
}

#endif
