## Copyright, 2001, Astra Network Inc.  All Rights Reserved

## This source code has been published by Astra Network Inc. However, any
## use, reproduction, modification, distribution or transfer of this
## software, or any software which includes or is based upon any of this
## code, is only permitted if expressly authorized by a written license
## agreement from Astra. Contact your Astra representitive directly for
## more information.

TOPDIR:=%%TOPDIR%%
include $(TOPDIR)/mkfiles/def_glob.mk


MODULES:=$(subst /,,$(wildcard mod_*/))
MODULES_MAKEFILES:=$(foreach dir, $(MODULES), $(addsuffix /Makefile, $(dir)))
MODULE_LIBS:=$(foreach dir, $(MODULES), $(dir)/lib$(subst /,,$(dir))S.a)

LIBS:=$(foreach dir, $(MODULES), -l$(subst /,,$(dir))S)

PKGS:=$(subst /,,$(wildcard pkg_*/))
PKGS_MAKEFILES:=$(foreach dir, $(PKGS), $(addsuffix /Makefile, $(dir)))

MOD_INCLUDE_DIRS:=$(foreach dir, $(MODULES), -I$(dir) -I$(MODDIR)/$(dir))

SRCS:=$(basename $(notdir $(wildcard $(OLRTDIR)/*.[c])))
ifeq "$(PLAT)" "qnx4"
SRCS:=$(filter-out module_dload,$(SRCS))
else
SRCS:=$(filter-out module_sload,$(SRCS))
endif
OBJS:=$(addsuffix .o, $(SRCS))

LINTSRCS:=$(addprefix $(OLRTDIR)/, $(addsuffix .c, $(SRCS)))

VPATH:= $(OLRTDIR) ./

CFLAGS:=$(INCLUDEDIRS) -I $(OLRTDIR) -I ./ $(foreach dir,$(MODULES), -L$(dir)) $(MOD_INCLUDE_DIRS) $(DEBUG) 

all: $(TOPDIR)/version.h olrt $(PKGS)

$(TOPDIR)/version.h:
	$(MAKE) -C $(TOPDIR)/../build version.h

$(MODULES): $(MODULES_MAKEFILES)
	$(MAKE) -C $@

$(MODULE_LIBS): $(MODULES_MAKEFILES)
	$(MAKE) -C $(dir $@)

# FIX ME - I need a prerequisit here.
$(MODULES_MAKEFILES): 
	$(CPMKFILE) $(MODDIR)/$(dir $@)/mod.mk $@


$(PKGS): $(PKGS_MAKEFILES)
	$(MAKE) -C $@

$(PKGS_MAKEFILES): $(MKFILEDIR)/pkg.mk
	$(CPMKFILE) $^ $@


Makefile: $(OLRTDIR)/component.mk
	$(CPMKFILE) $^ $@
	@echo "ERROR: Makefile was out of date, it has been updated. Please remake." && /bin/false

TABLEDEPS:=$(foreach dir, $(MODULES),$(dir)/$(subst mod_,,$(dir)_olmod.h))

table.c: $(TABLEDEPS)
	@echo "Generating global_overlord_table in table.c" 
	@echo "//Automatically generated, do not edit." > table.c
	@echo "#include <olmod.h>" >> table.c
	@(for x in $(MODULES); do echo "#include <$$x.h>"; done) | sed s/mod_//g | sed s,/.h,.h,g >> table.c
	@echo "const olmod_module_t object_global_overlord_table[] = {" >> table.c
	@cat /dev/null $(TABLEDEPS) >> table.c
	@echo "END_OBJECT_TABLE };" >> table.c

clean:
	-rm -f *.o overlord table.c
	$(foreach dir, $(MODULES) $(PKGS), $(MAKE) -C $(dir) clean;)

# FIX ME - the makefiles target is not supposed to be phony, it just
#          needs to as there is no prerequisite
.PHONY: $(MODULES) clean all $(MODULES_MAKEFILES) $(PKGS)

olrt: $(MODULE_LIBS) $(OBJS) table.o
	$(CC) $(CFLAGS) $(OBJS) table.o $(DLLIB) $(RTLIB) $(QUADLIB) $(UNIXLIB) $(DLFLAGS) $(LIBS) -o $@

lint: $(LINTSRCS) 
	$(LINT) $(INCLUDEDIRS) $(LINTFLAGS) $(LINTSRCS)

install: olrt $(PKGS_MAKEFILES)
	cp olrt $(INSTALLDIR)
	$(foreach dir, $(PKGS), $(MAKE) -C $(dir) $@; )

deps: $(SRCS)
	$(DEPS) $^ > deps.mk

-include deps.mk

test: test/Makefile
	$(foreach dir, $(PKGS) $(MODULES), $(MAKE) -C $(dir) $@; )
	$(MAKE) -C test test

test/Makefile: $(TOPDIR)/olrt/test/test.mk
	@mkdir test 2> /dev/null || /bin/true
	$(CPMKFILE) $< $@
