// Copyright, 2001-2003, Astra Network Inc.  All Rights Reserved

// This source code has been published by Astra Network Inc. However, any
// use, reproduction, modification, distribution or transfer of this
// software, or any software which includes or is based upon any of this
// code, is only permitted if expressly authorized by a written license
// agreement from Astra. Contact your Astra representative directly for
// more information.

#include <olmod.h>
#include <fd_struct.h>

olmod_error_t
fd_module_init ()
{
  return kMod_OK;
}

olmod_blackbox_t *
fd_module_inst (pid_t process, olmod_arglist_t * static_args)
{
  fd_data_t *blackbox;

  if (!(blackbox = (fd_data_t *) malloc (sizeof (fd_data_t))))
    {
      printf ("mod_fd: malloc failed\n");
      return NULL;
    }
  blackbox->process = process;

  return blackbox;
}

olmod_error_t
fd_module_set (olmod_blackbox_t * data, int64_t var)
{
  return kMod_OK;
}

void
fd_module_deinst (olmod_blackbox_t * data)
{
  free (data);
}

void
fd_module_deinit ()
{
}
