// Copyright, 2001-2003, Astra Network Inc.  All Rights Reserved

// This source code has been published by Astra Network Inc. However, any
// use, reproduction, modification, distribution or transfer of this
// software, or any software which includes or is based upon any of this
// code, is only permitted if expressly authorized by a written license
// agreement from Astra. Contact your Astra representative directly for
// more information.

#include <olmod.h>
#include <fd_struct.h>
#include <sys/procfs.h>
#include <sys/stat.h>
#include <fcntl.h>

int64_t
fd_module_get (olmod_blackbox_t * data, olmod_arglist_t * dynamic_args)
{
  fd_data_t *blackbox = (fd_data_t *) data;
  procfs_info info;
  int fd;
  char filename[50];

  /* Get total fds used for the entire system */
  /* FIXME: Not done yet. */
  if (blackbox->process == 0)
    {
      return 0;
    }

  /* Get fds used for a specific process.
   * Source: procfs.h
   */

  /* FIXME: How big can this go? */
  snprintf (filename, 50, "/proc/%d/as", blackbox->process);

  if ((fd = open (filename, O_RDONLY)) == -1)
    {
      fprintf (stderr, "mod_fd: open of %s failed\n", filename);
      return 0;
    }
  devctl (fd, DCMD_PROC_INFO, &info, sizeof (info), 0);

  close (fd);
  return info.num_fdcons;
}
