// Copyright, 2001-2003, Astra Network Inc.  All Rights Reserved

// This source code has been published by Astra Network Inc. However, any
// use, reproduction, modification, distribution or transfer of this
// software, or any software which includes or is based upon any of this
// code, is only permitted if expressly authorized by a written license
// agreement from Astra. Contact your Astra representative directly for
// more information.

#include <olmod.h>
#include <fd_struct.h>
#include <stdlib.h>

#include <sys/stat.h>
#include <fcntl.h>
#include <limits.h>
#include <dirent.h>

int64_t
fd_module_get (olmod_blackbox_t * data, olmod_arglist_t * dynamic_args)
{
  fd_data_t *blackbox = (fd_data_t *) data;
  char fname[PATH_MAX];
  DIR *dir;
  int64_t count = 0;

  snprintf (fname, PATH_MAX, "/proc/%d/fd", blackbox->process);

  if ((dir = opendir (fname)) == NULL)
    {
      fprintf (stderr, "mod_fd: opendir of %s failed\n", fname);
      return 0;
    }

  while (readdir (dir) != NULL)
    {
      count++;
    }
  closedir (dir);

  return count - 2;  // minus 2 because of . and .. (directory entries).
}
