// Copyright, 2001-2003, Astra Network Inc.  All Rights Reserved

// This source code has been published by Astra Network Inc. However, any
// use, reproduction, modification, distribution or transfer of this
// software, or any software which includes or is based upon any of this
// code, is only permitted if expressly authorized by a written license
// agreement from Astra. Contact your Astra representative directly for
// more information.


#include <regex.h>
#include <unix.h>
#include <sys/kernel.h>
#include <sys/psinfo.h>

#include "olmod.h"

int64_t
getpidbyname_module_get (olmod_blackbox_t * data,
			 olmod_arglist_t * dynamic_args)
{
  regex_t namexp;
  pid_t process = 0;
  char *name = (char *) dynamic_args[0];
  char tbuf[256];
  struct _psinfo info;

  snprintf (tbuf, 256, "^(.*/)*%s$", name);
  regcomp (&namexp, tbuf, REG_EXTENDED | REG_NOSUB);

  process = 1;
  while ((process = qnx_psinfo (0, process, &info, 0, 0)) != -1)
    {
      if (regexec (&namexp, info.un.proc.name, 0, NULL, 0) != REG_NOMATCH)
	break;
      process++;
    }
  if (process == -1)
    process = 0;

  return LTOQ (process);
}
