// Copyright, 2001-2003, Astra Network Inc.  All Rights Reserved

// This source code has been published by Astra Network Inc. However, any
// use, reproduction, modification, distribution or transfer of this
// software, or any software which includes or is based upon any of this
// code, is only permitted if expressly authorized by a written license
// agreement from Astra. Contact your Astra representative directly for
// more information.


#include <olmod.h>
#include <errno.h>
#include <signal.h>

typedef struct kill_data_s
{
  pid_t process;
}
kill_data_t;


olmod_error_t
kill_module_init ()
{
  return kMod_OK;
}

olmod_blackbox_t *
kill_module_inst (pid_t process, olmod_arglist_t * static_args)
{
  kill_data_t *blackbox;

  if (!(blackbox = (kill_data_t *) malloc (sizeof (kill_data_t))))
    {
      printf ("mod_kill: malloc failed\n");
      return NULL;
    }
  blackbox->process = process;

  return blackbox;
}

olmod_error_t
kill_module_set (olmod_blackbox_t * data, int64_t var)
{
  return kMod_OK;
}

int64_t
kill_module_get (olmod_blackbox_t * data, olmod_arglist_t * dynamic_args)
{
  kill_data_t *blackbox = (kill_data_t *) data;

  if (kill (blackbox->process, *(int *) dynamic_args[0]) == -1)
    return (LTOQ (errno));
  else
    return (LTOQ (0l));
}


void
kill_module_deinst (olmod_blackbox_t * data)
{
  free (data);
}

void
kill_module_deinit ()
{
}
