// Copyright, 2001-2003, Astra Network Inc.  All Rights Reserved

// This source code has been published by Astra Network Inc. However, any
// use, reproduction, modification, distribution or transfer of this
// software, or any software which includes or is based upon any of this
// code, is only permitted if expressly authorized by a written license
// agreement from Astra. Contact your Astra representative directly for
// more information.

#include <stdio.h>
#include <olmod.h>
#include <log.h>

static olmod_module_t object_global_overlord_table[] = {
#include <log_olmod.h>
  END_OBJECT_TABLE
};
int logtype = 2;		/* output to stderr */

int
main ()
{
  olmod_blackbox_t *data;
  int i = 0;
  /* this is a hack, we would normally have to search the table for our
   * module, but we know it is the first and only one */
  olmod_module_t *mymod = &object_global_overlord_table[0];

  olmod_arglist_t static_args[2] = { (olmod_arglist_t) & logtype,
    (olmod_arglist_t) "LOG_MAIL"
  };

  olmod_arglist_t dynamic_args[2];
  int severity;

  (void) mymod->module_init ();


  data = mymod->module_inst ((pid_t) i, static_args);

  severity = 3;
  dynamic_args[0] = &severity;
  dynamic_args[1] = "This is the error message";

  printf ("get: %s\n", QTOSTR (mymod->module_get (data, dynamic_args)));

  mymod->module_deinst (data);

  mymod->module_deinit ();
  return 0;
}
