// Copyright, 2001-2003, Astra Network Inc.  All Rights Reserved

// This source code has been published by Astra Network Inc. However, any
// use, reproduction, modification, distribution or transfer of this
// software, or any software which includes or is based upon any of this
// code, is only permitted if expressly authorized by a written license
// agreement from Astra. Contact your Astra representative directly for
// more information.

#include <stdio.h>
#include <olmod.h>
#include <logf1.h>

olmod_module_t object_global_overlord_table[] = {
#include <logf1_olmod.h>
  END_OBJECT_TABLE
};

int logtype = 0;		/* output to stderr */

int
main ()
{
  olmod_blackbox_t *data;
  int i = 0, j;
  /* this is a hack, we would normally have to search the table for our
   * module, but we know it is the first and only one */
  olmod_module_t *mymod = &object_global_overlord_table[0];


  olmod_arglist_t static_args[] = { (olmod_arglist_t) & logtype,
    (olmod_arglist_t) "filename",
    (olmod_arglist_t) "Test %s"
  };

  olmod_arglist_t dynamic_args[2];
  int severity;
  int64_t count;

  mymod->module_init ();


  data = mymod->module_inst (i, static_args);

  severity = 3;
  dynamic_args[0] = &severity;

  for (count = LTOQ (1L); QLT (count, LTOQ (4L));
       count = QADD (count, LTOQ (1L)))
    {
      dynamic_args[1] = &count;

      printf ("get: %s\n", QTOSTR (mymod->module_get (data, dynamic_args)));
    }
  mymod->module_deinst (data);

  mymod->module_deinit ();
  return 0;
}
