// Copyright, 2001-2003, Astra Network Inc.  All Rights Reserved

// This source code has been published by Astra Network Inc. However, any
// use, reproduction, modification, distribution or transfer of this
// software, or any software which includes or is based upon any of this
// code, is only permitted if expressly authorized by a written license
// agreement from Astra. Contact your Astra representative directly for
// more information.

#include <olmod.h>
#include <mem_struct.h>


olmod_error_t
mem_module_init ()
{
  return kMod_OK;
}

olmod_blackbox_t *
mem_module_inst (pid_t process, olmod_arglist_t * static_args)
{
  mem_data_t *blackbox;

  if (!(blackbox = (mem_data_t *) malloc (sizeof (mem_data_t))))
    {
      printf ("mod_mem: malloc failed\n");
      return NULL;
    }
  switch (QTOL (*(int64_t *) static_args[0]))
    {
    case 0:
      blackbox->flags = HEAP;
      break;
    case 1:
      blackbox->flags = STACK | HEAP;
      break;
    case 2:
      blackbox->flags = CODE | DATA | STACK | HEAP;
      break;
    case 3:
      blackbox->flags = CODE | DATA | STACK | HEAP | SO;
      break;
    case 4:
      blackbox->flags = CODE | DATA | STACK | HEAP | SO | OTHER;
      break;
    default:
      blackbox->flags = 0;
    }

  blackbox->process = process;

  return blackbox;
}

olmod_error_t
mem_module_set (olmod_blackbox_t * data, int64_t var)
{
  return kMod_OK;
}


void
mem_module_deinst (olmod_blackbox_t * data)
{
  free (data);
}

void
mem_module_deinit ()
{
}
