// Copyright, 2001-2003, Astra Network Inc.  All Rights Reserved

// This source code has been published by Astra Network Inc. However, any
// use, reproduction, modification, distribution or transfer of this
// software, or any software which includes or is based upon any of this
// code, is only permitted if expressly authorized by a written license
// agreement from Astra. Contact your Astra representative directly for
// more information.


#include <olmod.h>

typedef struct test_data_s
{
  pid_t pid;
}
test_data_t;


const char *module = "test";

olmod_error_t
test_module_init ()
{
  printf ("mod_%s: module_init() called\n", module);
  return kMod_OK;
}

olmod_blackbox_t *
test_module_inst (pid_t process, olmod_arglist_t * static_args)
{
  test_data_t *data;

  printf ("mod_%s: module_inst() called\n", module);

  if (!(data = (test_data_t *) malloc (sizeof (test_data_t))))
    {
      printf ("mod_%s: malloc() failed\n", module);
      exit (1);
    }

  data->pid = process;

  return (olmod_blackbox_t *) data;
}

olmod_error_t
test_module_set (olmod_blackbox_t * data, int64_t var)
{
  printf ("mod_%s: module_set() called\n", module);
  return kMod_OK;
}

int64_t
test_module_get (olmod_blackbox_t * data, olmod_arglist_t * dynamic_args)
{
  test_data_t *mydata = (test_data_t *) data;
  printf ("mod_%s: module_get() called\n", module);
  printf (" - with pid == %d\n - Returning ULONGLONG_MAX\n", mydata->pid);

  return -1;
}

void
test_module_deinst (olmod_blackbox_t * data)
{
  printf ("mod_%s: module_deinst() called\n", module);

  free (data);
}

void
test_module_deinit ()
{
  printf ("mod_%s: module_deinit() called\n", module);
}
