// Copyright, 2001-2003, Astra Network Inc.  All Rights Reserved

// This source code has been published by Astra Network Inc. However, any
// use, reproduction, modification, distribution or transfer of this
// software, or any software which includes or is based upon any of this
// code, is only permitted if expressly authorized by a written license
// agreement from Astra. Contact your Astra representative directly for
// more information.

#include <stdio.h>
#include <olmod.h>
#include <test.h>

olmod_module_t object_global_overlord_table[] = {
#include <test_olmod.h>
  END_OBJECT_TABLE
};

const int NUM = 5;

int
main ()
{
  olmod_blackbox_t *data;
  int i, j;
  /* this is a hack, we would normally have to search the table for our
   * module, but we know it is the first and only one */
  olmod_module_t *mymod = &object_global_overlord_table[0];


  mymod->module_init ();

  for (i = 0; i < NUM; i++)
    {
      data = mymod->module_inst (i, NULL);

      for (j = 0; j < 3; j++)
	printf ("get: %s\n", QTOSTR (mymod->module_get (data, NULL)));

      mymod->module_deinst (data);

    }

  mymod->module_deinit ();

  return 0;
}
