// Copyright, 2001-2003, Astra Network Inc.  All Rights Reserved

// This source code has been published by Astra Network Inc. However, any
// use, reproduction, modification, distribution or transfer of this
// software, or any software which includes or is based upon any of this
// code, is only permitted if expressly authorized by a written license
// agreement from Astra. Contact your Astra representative directly for
// more information.

#include <stdio.h>
#include <olmod.h>
#include <var.h>

olmod_module_t object_global_overlord_table[] = {
#include <var_olmod.h>
  END_OBJECT_TABLE
};

int64_t temp;

int
main ()
{
  olmod_blackbox_t *data;

  /* this is a hack, we would normally have to search the table for our
   * module, but we know it is the first and only one */
  olmod_module_t *mymod = &object_global_overlord_table[0];

  olmod_arglist_t static_args[1] = { &temp };

  temp = LTOQ (123456789);

  mymod->module_init ();

  data = mymod->module_inst (0, static_args);

  printf ("get: %s\n", QTOSTR (mymod->module_get (data, NULL)));
  mymod->module_set (data, LTOQ (1));
  printf ("get: %s\n", QTOSTR (mymod->module_get (data, NULL)));
  mymod->module_set (data, LTOQ (2));
  printf ("get: %s\n", QTOSTR (mymod->module_get (data, NULL)));
  mymod->module_set (data, LTOQ (3));
  printf ("get: %s\n", QTOSTR (mymod->module_get (data, NULL)));
  mymod->module_set (data, LTOQ (4));
  printf ("get: %s\n", QTOSTR (mymod->module_get (data, NULL)));
  mymod->module_set (data, LTOQ (5));
  printf ("get: %s\n", QTOSTR (mymod->module_get (data, NULL)));

  mymod->module_deinst (data);

  mymod->module_deinit ();

  return 0;
}
