// Copyright, 2001-2003, Astra Network Inc.  All Rights Reserved

// This source code has been published by Astra Network Inc. However, any
// use, reproduction, modification, distribution or transfer of this
// software, or any software which includes or is based upon any of this
// code, is only permitted if expressly authorized by a written license
// agreement from Astra. Contact your Astra representative directly for
// more information.


#include <olmod.h>

typedef struct var_data_s
{
  int64_t data;
}
var_data_t;


olmod_error_t
var_module_init ()
{
  return kMod_OK;
}

olmod_blackbox_t *
var_module_inst (pid_t process, olmod_arglist_t * static_args)
{
  var_data_t *blackbox;

  if (!(blackbox = (var_data_t *) malloc (sizeof (var_data_t))))
    {
      printf ("mod_var: malloc failed\n");
      return NULL;
    }

  blackbox->data = *(int64_t *) static_args[0];

  return blackbox;
}

olmod_error_t
var_module_set (olmod_blackbox_t * data, int64_t var)
{
  var_data_t *blackbox = (var_data_t *) data;

  blackbox->data = var;

  return kMod_OK;
}

int64_t
var_module_get (olmod_blackbox_t * data, olmod_arglist_t * dynamic_args)
{
  var_data_t *blackbox = (var_data_t *) data;

  return blackbox->data;
}

void
var_module_deinst (olmod_blackbox_t * data)
{
  free (data);
}

void
var_module_deinit ()
{
}
