## Copyright, 2001, Astra Network Inc.  All Rights Reserved

## This source code has been published by Astra Network Inc. However, any
## use, reproduction, modification, distribution or transfer of this
## software, or any software which includes or is based upon any of this
## code, is only permitted if expressly authorized by a written license
## agreement from Astra. Contact your Astra representitive directly for
## more information.

TOPDIR:=%%TOPDIR%%
include $(TOPDIR)/mkfiles/def_glob.mk

CWD:=$(shell /bin/pwd)
OLC:=$(TOPDIR)/build-$(PLAT)/olc/olc -q
OLA:=$(TOPDIR)/build-$(PLAT)/ola/ola -q
OLRT:=$(TOPDIR)/build-$(PLAT)/olrt/olrt -q
QLIBDIR:=$(TOPDIR)/build-$(PLAT)/lib/quad

TS:=$(wildcard $(OLRTDIR)/test/*.script)

VPATH:=$(OLRTDIR)/test

SRCS:=$(sort $(notdir $(wildcard $(OLRTDIR)/test/*.c)))
OBJS:=$(sort $(addsuffix .o, $(basename $(notdir $(SRCS)))))

CFLAGS:=-g -I$(TOPDIR)/include -I$(OLRTDIR) -I$(OLRTDIR)/test -I../

test: testscript

lint:
	$(LINT) $(CFLAGS) $(LINTFLAGS) $(SRCS)

testscript: 
	@echo "olrt: Testing general functionality... "
	@if [ "X$(TS)" != "X" ]; then \
	   for test in $(TS)""; do \
             $(OLC) < $$test | $(OLA); \
             $(OLRT) 1> tmp.output 2>&1; \
             $$test.output > good.output; \
             if [ "X`diff good.output tmp.output`" = "X" ]; then \
				echo "Test `basename $$test` passed!"; \
             else \
				echo "Test `basename $$test` failed!"; \
				cat tmp.output; \
             fi; \
       done; \
	else \
		echo " - no tests here yet." ; \
	fi 
	-@rm -f good.output tmp.output p.out 
	@echo " "

clean:
	-rm -f $(OBJS) test p.out tmp.output



