/* Y o u r   D e s c r i p t i o n                       */
/*                            AppBuilder Photon Code Lib */
/*                                         Version 2.01  */

/* Standard headers */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

/* Local headers */
#include "ablibs.h"
#include "abimport.h"
#include "proto.h"


int
text_activate( PtWidget_t *widget, ApInfo_t *apinfo, PtCallbackInfo_t *cbinfo )
	{
	PtArg_t args[1];
	char *p;

	PtSetArg( &args[0], Pt_ARG_TEXT_STRING, &p, 0 );
	PtGetResources( ABW_text, 1, args );

	PtSetArg( &args[0], Pt_ARG_WEB_GET_URL, p, WWW_ACTION_DISPLAY );
	PtSetResources( ABW_web_client, 1, args );

	return( Pt_CONTINUE );
	}


int
web_status( PtWidget_t *widget, ApInfo_t *apinfo, PtCallbackInfo_t *cbinfo )
	{
	PtWebStatusCallback_t *cb = cbinfo->cbdata;

	switch(cb->type) {
		case WWW_STATUS_PRINT:
			PtFlush();
			if ( strstr( cb->desc, "Print Done" ) || strstr( cb->desc, "Print Error" ) ) {
				PtDestroyWidget( ABW_print_win );
				}
			break;
		}

	return( Pt_CONTINUE );
	}
