#!/bin/sh
#
# The contents of this file are subject to the Netscape Public License
# Version 1.0 (the "NPL"); you may not use this file except in
# compliance with the NPL.  You may obtain a copy of the NPL at
# http://www.mozilla.org/NPL/
#
# Software distributed under the NPL is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the NPL
# for the specific language governing rights and limitations under the
# NPL.
#
# The Initial Developer of this code under the NPL is Netscape
# Communications Corporation.  Portions created by Netscape are
# Copyright (C) 1998 Netscape Communications Corporation.  All Rights
# Reserved.
#

## $Id: mozilla,v 1.10 2001/01/23 15:34:56 cls%seawood.org Exp $
## 
## Usage:
##
## $ mozilla [args]
##
## This script is meant to run the mozilla-bin binary from either 
## mozilla/xpfe/bootstrap or mozilla/dist/bin.
##
## The script will setup all the environment voodoo needed to make
## the mozilla-bin binary to work.
##

#uncomment for debugging
#set -x

dist_bin=`dirname $0`
script_args=""
moreargs=""
debugging=0
MOZILLA_BIN="mozserver"

if [ "$OSTYPE" = "beos" ]; then
  mimeset -F $MOZILLA_BIN
fi

while [ $# -gt 0 ]
do
  case "$1" in
    -s | -server)
      MOZILLA_BIN="mozserver"
      shift
      ;;
    -p | -pure)
      MOZILLA_BIN="mozilla-bin.pure"
      shift
      ;;
    -g | --debug)
      script_args="$script_args -g"
      debugging=1
      shift
      ;;
    -d | --debugger)
      script_args="$script_args -d $2"
      shift 2
      ;;
    *)
      moreargs="$moreargs \"$1\""
      shift 1
      ;;
  esac
done

eval "set -- $moreargs"
#echo $dist_bin/run-mozilla.sh $script_args $dist_bin/$MOZILLA_BIN "$@"
cd /opt/Mozilla/mozilla
exec $dist_bin/run-mozilla.sh $script_args $dist_bin/$MOZILLA_BIN "$@"
