/*
 * videoio.h
 *
 * Video I/O Device handers
 *
 * Open H323 Library
 *
 * Copyright (c) 1998-2000 Equivalence Pty. Ltd.
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Open H323 Library.
 *
 * The Initial Developer of the Original Code is Equivalence Pty. Ltd.
 *
 * Contributor(s): ______________________________________.
 *
 * $Log: videoio.h,v $
 * Revision 1.2  2002/11/20 04:26:32  xtang
 * Orignal 1-10-4 package.
 *
 * Revision 1.12  2002/09/16 01:14:15  robertj
 * Added #define so can select if #pragma interface/implementation is used on
 *   platform basis (eg MacOS) rather than compiler, thanks Robert Monaghan.
 *
 * Revision 1.11  2002/08/05 10:03:47  robertj
 * Cosmetic changes to normalise the usage of pragma interface/implementation.
 *
 * Revision 1.10  2001/09/11 01:24:36  robertj
 * Added conditional compilation to remove video and/or audio codecs.
 *
 * Revision 1.9  2001/02/09 05:16:24  robertj
 * Added #pragma interface for GNU C++.
 *
 * Revision 1.8  2000/12/19 22:33:44  dereks
 * Adjust so that the video channel is used for reading/writing raw video
 * data, which better modularizes the video codec.
 *
 * Revision 1.7  2000/05/18 11:53:34  robertj
 * Changes to support doc++ documentation generation.
 *
 * Revision 1.6  2000/05/02 04:32:25  robertj
 * Fixed copyright notice comment.
 *
 * Revision 1.5  2000/02/25 13:39:50  craigs
 * Added ability to disable local video window via null video device
 *
 * Revision 1.4  2000/02/04 05:00:08  craigs
 * Changes for video transmission
 *
 * Revision 1.3  1999/11/29 08:59:56  craigs
 * Added new stuff for new video codec interface
 *
 * Revision 1.2  1999/11/01 00:52:00  robertj
 * Fixed various problems in video, especially ability to pass error return value.
 *
 * Revision 1.1  1999/09/21 08:12:50  craigs
 * Added support for video codecs and H261
 *
 */

#ifndef __VIDEOIO_H
#define __VIDEOIO_H

#ifdef P_USE_PRAGMA
#pragma interface
#endif


#include <ptlib.h>



#ifndef NO_H323_VIDEO

///////////////////////////////////////////////////////////////////////////////

/**Base class for the output of video data from a video codec.
  */
class H323VideoDevice : public PVideoOutputDevice
{
  PCLASSINFO(H323VideoDevice, PVideoOutputDevice);

  public:
  /**Constructor.
     */
    H323VideoDevice();

    /**Close device 
     */
    virtual BOOL Close();

  BOOL Open(const class PString &, BOOL = 1)
        { return TRUE; 
        }

  PStringList GetDeviceNames() const
      {  PStringList a;
      return a;      
      }
       
  PINDEX GetMaxFrameBytes()
      { return (352*288*3)>>1;
      }
  
    /**Test to determine if class is open or not.
     */
  BOOL IsOpen() 
      { return ( GetFrameWidth()>0 );  }
  
  BOOL Start() 
      { return TRUE;     }
  BOOL Stop() 
      { return TRUE;     }

  BOOL IsCapturing()
      { return FALSE; 
      }
  
    virtual void SetNow(int _now)  { now = _now; }

    virtual BOOL Redraw(const void * frame);

  protected:
    virtual BOOL WriteLineSegment(int x, int y, unsigned len, const BYTE * data) = 0;
  
    BOOL rgbReverseOrder;
    int now;
    BOOL suppress;
};


/**Dummy implementation for output of video data.
  */
class NullVideoOutputDevice : public H323VideoDevice
{
  PCLASSINFO(NullVideoOutputDevice, H323VideoDevice);

  public:
    NullVideoOutputDevice()
     : H323VideoDevice() { }

    virtual BOOL Redraw(const void * /*frame*/ )
      { return TRUE; }

    BOOL WriteLineSegment(int, int, unsigned, const BYTE *) { return TRUE; }
};


/**Class to output video data to a series of PPM files.
  */
class PPMVideoOutputDevice : public H323VideoDevice
{
  PCLASSINFO(PPMVideoOutputDevice, H323VideoDevice);

  public:
    PPMVideoOutputDevice();
    PPMVideoOutputDevice(int idno);

    virtual BOOL Redraw(const void * frame);

  protected:
    BOOL WriteLineSegment(int x, int y, unsigned len, const BYTE * data);
    
    int deviceID;
    int frameNumber;
    PFile file;
    PBYTEArray buffer;
};


#endif // NO_H323_VIDEO


#endif // __VIDEOIO_H


// End of File ///////////////////////////////////////////////////////////////
