#!/bin/ksh

grep postfix /etc/passwd > /dev/null 2>&1
if [ x"$?" = "x1" ]
then
    echo Adding postfix user to /etc/passwd.
    echo postfix:*:10000:10000:postfix:/no/where:/no/shell >> /etc/passwd
fi

grep postfix /etc/group > /dev/null 2>&1
if [ x"$?" = "x1" ]
then
    echo Adding postfix group to /etc/passwd.
    echo postfix:*:10000: >> /etc/group
fi

grep postdrop /etc/group > /dev/null 2>&1
if [ x"$?" = "x1" ]
then
    echo Adding postdrop group to /etc/group.
    echo postdrop:*:10001: >> /etc/group
fi

if [ ! -d /var/spool/postfix ]
then
    echo Setting Up /var/spool/postfix...
    mkdir /var/spool/postfix
    chown root:root /var/spool/postfix
fi

echo Fixing up perms for mail access...
chown root:postdrop /opt/sbin/postqueue
chmod g+s /opt/sbin/postqueue
chown root:postdrop /opt/sbin/postdrop
chmod g+s /opt/sbin/postdrop

echo
echo Done!
echo

