#!/bin/sh

function addto_services {
	grep ^$1 /etc/services > /dev/null 2>&1
	if [ "$?" = "1" ] 
	then
		echo $1 $2 >> /etc/services
		echo $1 $3 >> /etc/services
	fi
}


function addto_inetdconf {
	grep ^$1 /etc/inetd.conf > /dev/null 2>&1
	if [ "$?" = "1" ] 
	then
		echo $1 $2 >> /etc/inetd.conf
	fi
}



echo
echo imap post-install script
echo

echo  o Patching /etc/services for imap/pop entries.
addto_services  "imap"   "143/tcp imap2 imap4" "143/udp imap2 imap4" 
addto_services  "imaps"  "993/tcp" "993/udp" 
addto_services  "pop2"   "109/tcp postoffice" "109/udp postoffice"
addto_services  "pop3"   "110/tcp" "110/udp"
addto_services  "pop3s"  "995/tcp spop3" "995/udp spop3"

echo  o Patching /etc/inetd.conf for imapd/popd entries.
addto_inetdconf "imap4" "stream tcp nowait root /opt/sbin/imapd imapd"
addto_inetdconf "imaps" "stream tcp nowait root /opt/sbin/imapd imapd"
addto_inetdconf "pop2" "stream tcp nowait root /opt/sbin/ipop2d ipop2d"
addto_inetdconf "pop3" "stream tcp nowait root /opt/sbin/ipop3d ipop3d"
addto_inetdconf "pop3s" "stream tcp nowait root /opt/sbin/ipop3d ipop3d"

echo  o Restarting inetd.
slay -f -s SIGHUP inetd

echo
echo Complete.
echo

